/*
 * Decompiled with CFR 0.152.
 */
package itx.core.web;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.BaseController;
import itx.erp.ErpObjectContainer;
import itx.erp.base.model.WebSession;
import itx.erp.base.util.LangUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jtbcore.exception.FileException;
import jtbcore.model.KeyValueList;
import jtbcore.util.BooleanUtil;
import jtbcore.util.DateUtil;
import jtbcore.util.FileUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;
import jtbcore.util.WebUtil;

public class WebRequest {
    protected static Boolean desktopMode = false;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected KeyValueList json = null;
    protected Map<String, String> multiparts = null;
    protected BaseController controller = null;
    protected WebSession webSession;
    protected String routeUrl = null;
    public RequestType requestType;

    static {
        try {
            desktopMode = ErpObjectContainer.getInstance().getAppConfig().isDesktopMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public WebRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        String contentType = request.getHeader("Content-Type");
        if (contentType == null) {
            contentType = "";
        }
        contentType = contentType.toLowerCase();
        this.requestType = "GET".equals(request.getMethod()) ? RequestType.GET : (contentType.startsWith("application/json") ? RequestType.JSON : (contentType.startsWith("multipart/form-data") ? RequestType.MULTIPART : ("POST".equals(request.getMethod()) ? RequestType.POST : RequestType.OTHER)));
        if (this.requestType == RequestType.JSON) {
            this.json = KeyValueList.fromJson((InputStream)request.getInputStream());
        }
        if (this.requestType == RequestType.MULTIPART) {
            this.initMultiparts();
        }
    }

    public BaseController getController() {
        return this.controller;
    }

    public void setController(BaseController controller) {
        this.controller = controller;
    }

    public WebSession getWebSession() {
        return this.webSession;
    }

    public void setWebSession(WebSession webSession) {
        this.webSession = webSession;
    }

    public String getRouteUrl() {
        if (this.routeUrl == null) {
            String relayPath = this.request.getHeader("Return2Base-Relay-Path");
            this.routeUrl = this.request.getRequestURI();
            if (relayPath != null && this.routeUrl.indexOf(relayPath) != -1) {
                this.routeUrl = this.routeUrl.substring(relayPath.length());
            } else {
                int contextPathLen = this.request.getContextPath().length();
                if (contextPathLen > 0) {
                    this.routeUrl = this.routeUrl.substring(contextPathLen);
                }
            }
        }
        return this.routeUrl;
    }

    public String getRemoteIp() {
        String ip = this.request.getHeader("X-Forwarded-For");
        if (ip == null) {
            ip = this.request.getRemoteAddr();
        }
        return ip;
    }

    public boolean isRelayRequest() {
        return this.request.getRemotePort() == 0;
    }

    public boolean isEmbeddedRequest() {
        String ua;
        return desktopMode != false && (ua = this.request.getHeader("User-Agent")) != null && ua.indexOf("JavaFX") != -1;
    }

    public KeyValueList getKvl() {
        return this.json;
    }

    public void initMultiparts() throws IOException {
        try {
            Collection parts = this.request.getParts();
            this.multiparts = new HashMap<String, String>();
            for (Part p : parts) {
                if (p.getSize() > 1000L) continue;
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream is = p.getInputStream();){
                    String v = StringUtil.inputStream2String(is);
                    this.multiparts.put(p.getName(), v);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (ServletException | IOException e) {
            e.printStackTrace();
        }
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public void setStatus(Integer statusCode) {
        this.response.setStatus(statusCode.intValue());
    }

    public Integer getUserId() {
        if (this.webSession != null && this.webSession.getUserId() != null) {
            return this.webSession.getUserId();
        }
        return null;
    }

    public Set<String> getParameterNames() {
        if (this.requestType == RequestType.JSON) {
            return this.json.getKeyValueMap().keySet();
        }
        return this.request.getParameterMap().keySet();
    }

    public boolean notEmpty(String name) {
        String v = this.getParameter(name);
        return v != null && v.trim().length() > 0;
    }

    public boolean hasParameter(String name) {
        String v = this.getParameter(name);
        return v != null && v.trim().length() > 0;
    }

    public String getParameter(String name) {
        if (this.requestType == RequestType.JSON) {
            return this.json.getValue(name);
        }
        if (this.requestType == RequestType.MULTIPART) {
            return this.multiparts.get(name);
        }
        return this.request.getParameter(name);
    }

    public String getParameterTrim(String name) {
        String n = this.getParameter(name);
        if (n == null) {
            return "";
        }
        return n.trim();
    }

    public Date getParamDate(String paramName) {
        String d = this.getParameter(paramName);
        return DateUtil.string2date(d);
    }

    public Date getParamDateTime(String paramName) {
        String d = this.getParameter(paramName);
        if (d != null && (d.matches("^\\d{4}-\\d{2}-\\d{2}$") || d.matches("^\\d{2}-\\d{2}-\\d{4}$"))) {
            Date d2 = DateUtil.string2date(d);
            d2.setHours(0);
            return d2;
        }
        return DateUtil.string2datetime(d);
    }

    public Boolean getParamBool(String paramName) {
        String s = this.getParameter(paramName);
        if (BooleanUtil.isTrue(s).booleanValue()) {
            return true;
        }
        return false;
    }

    public Integer getParamInt(String paramName) {
        return this.getParamInt(paramName, null);
    }

    public Integer getParamInt(String paramName, Integer defaultValue) {
        Integer i;
        String p = this.getParameter(paramName);
        if (p != null && (i = NumberUtil.tryParseInt(p)) != null) {
            return i;
        }
        return defaultValue;
    }

    public Integer getParamIntStripPrefix(String paramName) {
        String s = this.getParameter(paramName);
        if (s == null) {
            return null;
        }
        s = s.replaceAll("^[a-zA-Z-]+", "");
        return NumberUtil.tryParseInt(s);
    }

    public Double getParamDouble(String paramName) {
        String p = this.getParameter(paramName);
        Double d = NumberUtil.tryParseDouble(p);
        return d;
    }

    public Double getParamCurrencyAsDouble(String paramName) {
        String p = this.getParameter(paramName);
        Double d = NumberUtil.tryCurrencyToDouble(p);
        return d;
    }

    public void renderJson(Object obj) throws StreamWriteException, DatabindException, IOException {
        this.response.setContentType("application/json; charset=UTF-8");
        ServletOutputStream os = this.response.getOutputStream();
        ObjectMapper om = new ObjectMapper();
        om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, obj);
        os.flush();
    }

    public void renderJsonErrorMessage(String message) throws StreamWriteException, DatabindException, IOException {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("error", true);
        r.put("message", message);
        r.put("message_nl", LangUtil.getInstance().t(message));
        this.renderJson(r);
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        if (cookies == null) {
            return null;
        }
        int x = 0;
        while (x < cookies.length) {
            if (name.equals(cookies[x].getName())) {
                return cookies[x];
            }
            ++x;
        }
        return null;
    }

    public String getCookieValue(String name) {
        Cookie c = this.getCookie(name);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    public void setCookie(String name, String val) {
        this.setCookie(name, val, -1);
    }

    public void setCookie(String name, String val, int maxAge) {
        Cookie old = this.getCookie(name);
        if (old != null && (val == null && old.getValue() == null || val.equals(old.getValue()))) {
            return;
        }
        Cookie c = new Cookie(name, val);
        c.setPath(this.request.getContextPath() + "/");
        c.setMaxAge(maxAge);
        this.response.addCookie(c);
    }

    public void outputFile(String path) throws FileException, FileNotFoundException, IOException {
        File f = new File(path);
        if (!f.exists()) {
            throw new FileException("File not found: " + path);
        }
        this.getResponse().setHeader("Content-Type", WebUtil.contentTypeByFilename(path));
        this.getResponse().setHeader("Content-Disposition", "attachment; filename=\"" + f.getName() + "\"");
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
            FileUtil.copy((InputStream)bis, (OutputStream)this.getResponse().getOutputStream());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void printRequestHeaders() {
        Enumeration hnames = this.request.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            System.out.println("Header: " + hname + "\t" + this.request.getHeader(hname));
        }
    }

    public static enum RequestType {
        GET,
        POST,
        JSON,
        MULTIPART,
        OTHER;

    }
}

